/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.paterva.maltego.util.ui.GotoUrl;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.spi.flamingo.RibbonDefaultRolloverProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;

public class RecentFilesRolloverProvider
extends RibbonDefaultRolloverProvider {
    private static final boolean RECENT_FILES_TEST = false;

    public void menuEntryActivated(JPanel panel) {
        boolean noCloudLogin;
        panel.removeAll();
        JCommandButtonPanel openHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
        String groupName = "Recent Documents";
        openHistoryPanel.addButtonGroup(groupName);
        Color color = UIManager.getLookAndFeelDefaults().getColor("ribbon-app-menu-secondary-bg");
        if (color != null) {
            color = new Color(color.getRGB());
            openHistoryPanel.setBackground(color);
        }
        List<String> mRUFileList = RecentFiles.getInstance().getMRUFileList();
        for (final String s2 : mRUFileList) {
            try {
                final File file = Utilities.toFile((URI)URI.create(s2));
                JCommandButton historyButton = new JCommandButton(file.getName());
                historyButton.setHorizontalAlignment(2);
                openHistoryPanel.addButtonToLastGroup((AbstractCommandButton)historyButton);
                historyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        FileObject fo = FileUtil.toFileObject((File)file);
                        if (fo == null) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            RecentFiles.getInstance().removeFile(s2);
                        } else {
                            try {
                                DataObject dao = DataObject.find((FileObject)fo);
                                if (dao != null) {
                                    OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                                    open.open();
                                }
                            }
                            catch (DataObjectNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        boolean bl = noCloudLogin = !CloudAuth.getDefault().isCloudAuthEnabled() || !CloudAuth.getDefault().isAuthorized();
        if (noCloudLogin) {
            openHistoryPanel.setMaxButtonColumns(1);
            panel.setLayout(new BorderLayout());
            panel.add((Component)openHistoryPanel, "Center");
        } else {
            JCommandButton emptyButton = new JCommandButton("");
            emptyButton.setHorizontalAlignment(2);
            emptyButton.setEnabled(false);
            if (mRUFileList.isEmpty()) {
                emptyButton.setPreferredSize(new Dimension(0, 0));
            }
            openHistoryPanel.addButtonToLastGroup((AbstractCommandButton)emptyButton);
            openHistoryPanel.setMaxButtonColumns(1);
            panel.setLayout(new BorderLayout());
            panel.add((Component)openHistoryPanel, "North");
            JCommandButtonPanel openCloudHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
            openCloudHistoryPanel.addButtonGroup("Cloud");
            if (color != null) {
                openCloudHistoryPanel.setBackground(color);
            }
            JCommandButton gotoVault = new JCommandButton("Open Cases");
            gotoVault.setIcon(ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/resources/browse.png"));
            gotoVault.setHorizontalAlignment(2);
            openCloudHistoryPanel.addButtonToLastGroup((AbstractCommandButton)gotoVault);
            gotoVault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    GotoUrl.show((String)CloudAuth.getDefault().getCloudCasesUrl());
                }
            });
            RecentCloudGraphs recentCloudGraphs = RecentCloudGraphs.getDefault();
            String[] cloudGraphIds = recentCloudGraphs.getCloudGraphIds();
            String[] cloudGraphNames = recentCloudGraphs.getCloudGraphNames();
            for (int i = 0; i < cloudGraphIds.length && i < 10; ++i) {
                final String cloudGraphId = cloudGraphIds[cloudGraphIds.length - i - 1];
                String cloudGraphName = cloudGraphNames[cloudGraphNames.length - i - 1];
                try {
                    JCommandButton historyButton = new JCommandButton("\u2601 " + cloudGraphName);
                    historyButton.setHorizontalAlignment(2);
                    historyButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e2) {
                            RecentCloudGraphs.getDefault().open(cloudGraphId);
                        }
                    });
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            openCloudHistoryPanel.setMaxButtonColumns(1);
            panel.add((Component)openCloudHistoryPanel, "Center");
        }
    }
}

