/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.pws.api.OAuthAuthenticator;
import com.paterva.maltego.pws.api.OAuthAuthenticatorBuilder;
import com.paterva.maltego.pws.api.OAuthVersion;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServiceFactory;
import com.paterva.maltego.transform.protocol.api.OAuthAuthenticatorInfo;
import java.util.Collections;
import java.util.Map;

public class WebServiceTranslator {
    public Map<PublicWebService, String> translate(OAuthAuthenticatorInfo a) {
        OAuthAuthenticator authenticator = this.translateAuthenticator(a);
        PublicWebService service = PublicWebServiceFactory.getDefault().create(authenticator, true);
        return Collections.singletonMap(service, a.getIcon());
    }

    private OAuthAuthenticator translateAuthenticator(OAuthAuthenticatorInfo a) {
        OAuthAuthenticatorBuilder builder = OAuthAuthenticatorBuilder.getDefault();
        builder.accessTokenEndpoint(a.getAccessTokenEndpoint());
        builder.accessTokenInput(a.getAccessTokenInput());
        builder.accessTokenPublicKey(a.getAccessTokenPublicKey());
        builder.appKey(a.getAppKey());
        builder.appSecret(a.getAppSecret());
        builder.authorizationUrl(a.getAuthorizationUrl());
        builder.callbackPort(a.getCallbackPort());
        builder.description(a.getDescription());
        builder.displayName(a.getDisplayName());
        builder.name(a.getName());
        builder.oAuthVersion(OAuthVersion.parse((String)a.getOAuthVersion()));
        builder.refreshTokenEndpoint(a.getRefreshTokenEndpoint());
        builder.requestTokenEndpoint(a.getRequestTokenEndpoint());
        builder.requestTypeForAccessToken(a.getRequestTypeForAccessToken());
        builder.requestTypeForAuthorizationUrl(a.getRequestTypeForAuthorizationUrl());
        builder.requestTypeForRequestToken(a.getRequestTypeForRequestToken());
        builder.useSSLHost(a.useSSLHost());
        builder.useClientAuthorizationHeader(a.useClientAuthorizationHeader());
        return builder.build();
    }
}

