/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class TokenExchangeContext {
    private final KeycloakSession session;
    private final MultivaluedMap<String, String> formParams;
    private final Object cors;
    private final Object tokenManager;
    private final ClientModel client;
    private final RealmModel realm;
    private final EventBuilder event;
    private ClientConnection clientConnection;
    private HttpHeaders headers;
    private Map<String, String> clientAuthAttributes;
    private final Params params = new Params();

    public TokenExchangeContext(KeycloakSession session, MultivaluedMap<String, String> formParams, Object cors, RealmModel realm, EventBuilder event, ClientModel client, ClientConnection clientConnection, HttpHeaders headers, Object tokenManager, Map<String, String> clientAuthAttributes) {
        this.session = session;
        this.formParams = formParams;
        this.cors = cors;
        this.client = client;
        this.realm = realm;
        this.event = event;
        this.clientConnection = clientConnection;
        this.headers = headers;
        this.tokenManager = tokenManager;
        this.clientAuthAttributes = clientAuthAttributes;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public MultivaluedMap<String, String> getFormParams() {
        return this.formParams;
    }

    public Object getCors() {
        return this.cors;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getTokenManager() {
        return this.tokenManager;
    }

    public Map<String, String> getClientAuthAttributes() {
        return this.clientAuthAttributes;
    }

    public Params getParams() {
        return this.params;
    }

    public class Params {
        public String getActorToken() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"actor_token");
        }

        public String getActorTokenType() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"actor_token_type");
        }

        public String getAudience() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"audience");
        }

        public String getResource() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"resource");
        }

        public String getRequestedTokenType() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"requested_token_type");
        }

        public String getScope() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"scope");
        }

        public String getSubjectToken() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"subject_token");
        }

        public String getSubjectTokenType() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"subject_token_type");
        }

        public String getSubjectIssuer() {
            return (String)TokenExchangeContext.this.formParams.getFirst((Object)"subject_issuer");
        }
    }
}

