/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.treelist;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.analytics.RunMachineEvent;
import com.paterva.maltego.automation.favs.MachineFavorites;
import com.paterva.maltego.automation.treelist.MachineRunProvider;
import com.paterva.maltego.automation.treelist.MachineRunningItem;
import com.paterva.maltego.automation.view.MachineActions;
import com.paterva.maltego.automation.view.startup.EntityNodePayload;
import com.paterva.maltego.automation.view.startup.Helper;
import com.paterva.maltego.automation.view.startup.RunActions;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunnableItem;
import com.paterva.maltego.runregistry.item.RunningItem;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ui.GotoUrl;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openide.util.Exceptions;

public class MachineRunItem
extends AbstractRunnableItem {
    private final String _machineName;
    private MachineRunningItem _child;
    private String rootComponent;

    public MachineRunItem(String machineName, String rootComponent) {
        this._machineName = machineName;
        this.rootComponent = rootComponent;
    }

    MachineDescriptor getMachine() {
        try {
            return MachineRepository.getDefault().get(this._machineName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public MachineRunningItem getChild() {
        return this._child;
    }

    public void setChild(MachineRunningItem child) {
        this._child = child;
    }

    public List<RunningItem> getChildren() {
        return this._child != null ? Collections.singletonList(this._child) : Collections.EMPTY_LIST;
    }

    public String getName() {
        return "machine." + this._machineName;
    }

    public String getDisplayName() {
        return this.getMachine().getDisplayName();
    }

    public String getDescription() {
        return this.getMachine().getDescription();
    }

    public String getLafPrefix() {
        return "machines-item-runnable";
    }

    public boolean canRun() {
        return true;
    }

    public void run(GraphID graphID, Set<EntityID> entityIDs) {
        RunMachineEvent.send(this._machineName, this.rootComponent);
        RunActions.runMachine(Helper.getTarget(), this.getMachine(), new EntityNodePayload(graphID, entityIDs));
    }

    public boolean hasSettings() {
        return true;
    }

    public void showSettings() {
        MachineActions.editMachine(this._machineName);
    }

    public boolean hasHelp() {
        MachineDescriptor machine = this.getMachine();
        if (machine != null) {
            String helpUrl = machine.getHelpUrl();
            return FastURL.isFastURL((String)helpUrl);
        }
        return false;
    }

    public void showHelp() {
        MachineDescriptor machine = this.getMachine();
        if (machine != null) {
            GotoUrl.show((String)machine.getHelpUrl());
        }
    }

    public void setFavorite(boolean favorite) {
        MachineFavorites.getDefault().setFavorite(this.getMachine(), favorite);
    }

    public boolean isFavorite() {
        MachineDescriptor md = this.getMachine();
        return md != null ? md.isFavorite() : false;
    }

    public boolean isShowIn(String componentName) {
        return MachineRunProvider.isShowIn(componentName);
    }
}

