/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.mtgx;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.mtgx.imex.MtgxSerializer;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;

public class MtgxDataObject
extends GraphDataObject {
    public MtgxDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
    }

    protected void loadGraphImpl(GraphID graphID) throws IOException {
        MtgxSerializer serializer = new MtgxSerializer();
        serializer.loadGraph(graphID, this.getPrimaryFile(), this.getPassword(), this.getFileType());
    }

    public void saveGraph(GraphID graphID, OutputStream stream, ProgressHandle handle, AtomicBoolean cancelled, GraphFileType fileType) throws IOException {
        MaltegoArchiveWriter writer = new MaltegoArchiveWriter(fileType.getMtzVersion(), stream);
        this.save(graphID, writer, handle, cancelled, fileType);
    }

    public void saveGraph(GraphID graphID, ZipFile zipFile, ZipParameters params, ProgressHandle handle, AtomicBoolean cancelled, GraphFileType fileType) throws IOException {
        MaltegoArchiveWriter writer = new MaltegoArchiveWriter(fileType.getMtzVersion(), zipFile, params);
        this.save(graphID, writer, handle, cancelled, fileType);
    }

    protected void save(GraphID graphID, MaltegoArchiveWriter writer, ProgressHandle handle, AtomicBoolean cancelled, GraphFileType fileType) throws IOException {
        new MtgxSerializer().save(graphID, writer, handle, cancelled, fileType);
    }
}

