/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class SelectableIcon
implements Comparable<SelectableIcon> {
    private final String _iconCategory;
    private final String _iconName;
    private List<IconDescriptor> _icons;
    private IconMetadata _metadata;
    private boolean _selected;

    public SelectableIcon(String iconCategory, String iconName, boolean isSelected) {
        Args.notNullOrBlank((String)iconCategory, (String)"iconCategory");
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        this._iconCategory = iconCategory;
        this._iconName = iconName;
        this._selected = isSelected;
    }

    public String getIconCategory() {
        return this._iconCategory;
    }

    public String getIconName() {
        return this._iconName;
    }

    public synchronized List<IconDescriptor> getIcons() {
        if (this._icons == null) {
            this._icons = new ArrayList<IconDescriptor>();
        }
        return this._icons;
    }

    public IconDescriptor getIcon(IconSize size) {
        for (IconDescriptor icon : this.getIcons()) {
            if (icon.getSize() != size) continue;
            return icon;
        }
        return null;
    }

    public Optional<IconMetadata> getMetadata() {
        return Optional.ofNullable(this._metadata);
    }

    public void setMetadata(IconMetadata metadata) {
        this._metadata = metadata;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean isSelected) {
        this._selected = isSelected;
    }

    @Override
    public int compareTo(SelectableIcon o) {
        return this._iconName.compareTo(o._iconName);
    }
}

