/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.matching;

import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class MatchingRuleFactory {
    private static Map<MatchingRuleDescriptor, MatchingRule> _cache;
    private static final Collection<? extends MatchingRuleFactory> _factories;

    public abstract boolean isSupported(MatchingRuleDescriptor var1);

    public abstract MatchingRule create(MatchingRuleDescriptor var1);

    public static void setCacheEnabled(boolean enabled) {
        _cache = enabled ? new HashMap() : null;
    }

    public static MatchingRule createFrom(MatchingRuleDescriptor descriptor) {
        MatchingRule rule = null;
        if (_cache != null) {
            rule = _cache.get(descriptor);
        }
        if (rule == null) {
            for (MatchingRuleFactory matchingRuleFactory : _factories) {
                if (!matchingRuleFactory.isSupported(descriptor) || (rule = matchingRuleFactory.create(descriptor)) == null || _cache == null) continue;
                _cache.put(descriptor, rule);
            }
        }
        if (rule == null) {
            throw new IllegalArgumentException("No factory found to create MatchingRule from " + descriptor);
        }
        return rule;
    }

    static {
        _factories = Lookup.getDefault().lookupAll(MatchingRuleFactory.class);
    }
}

