/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import org.openide.awt.StatusDisplayer;

public class BulkStatusDisplayer {
    private final String _msg;
    private final long _interval;
    private int _count = 0;
    private long _lastUpdate = 0L;

    public BulkStatusDisplayer(String msg) {
        this(msg, 100L);
    }

    public BulkStatusDisplayer(String msg, long interval) {
        this._msg = msg;
        this._interval = interval;
        this._lastUpdate = System.currentTimeMillis();
    }

    public void increment() {
        ++this._count;
        long now = System.currentTimeMillis();
        if (now - this._lastUpdate > this._interval) {
            StatusDisplayer.getDefault().setStatusText(String.format(this._msg, this._count));
            this._lastUpdate = now;
        }
    }

    public void clear() {
        StatusDisplayer.getDefault().setStatusText("");
    }
}

