; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefix=SSE2
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefix=SSSE3
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefix=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefix=AVX1
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefix=AVX2
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefix=AVX512F
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefix=AVX512BW
;
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=slm | FileCheck %s --check-prefix=SLM
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=goldmont | FileCheck %s --check-prefix=SSE42
; RUN: opt < %s -mtriple=x86_64-apple-macosx10.8.0 -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=btver2 | FileCheck %s --check-prefix=AVX1

define i32 @mul_constpow2() {
; SSE2-LABEL: 'mul_constpow2'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:7 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:14 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:24 SizeLat:28 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:26 Lat:21 SizeLat:28 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:52 Lat:42 SizeLat:56 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:104 Lat:84 SizeLat:112 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'mul_constpow2'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:7 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:14 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:24 SizeLat:28 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:7 Lat:8 SizeLat:7 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:16 SizeLat:14 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:32 SizeLat:28 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:26 Lat:21 SizeLat:28 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:52 Lat:42 SizeLat:56 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:104 Lat:84 SizeLat:112 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'mul_constpow2'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:7 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:14 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:24 SizeLat:28 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:11 SizeLat:1 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:22 SizeLat:2 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:44 SizeLat:4 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:17 Lat:24 SizeLat:22 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:34 Lat:48 SizeLat:44 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:68 Lat:96 SizeLat:88 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'mul_constpow2'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:6 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:7 SizeLat:15 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:22 Lat:14 SizeLat:30 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:3 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:8 SizeLat:10 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:16 SizeLat:20 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:6 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:16 SizeLat:12 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:11 Lat:21 SizeLat:17 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:27 Lat:22 SizeLat:40 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:54 Lat:44 SizeLat:80 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'mul_constpow2'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:1 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:2 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:8 SizeLat:4 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:3 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:8 SizeLat:6 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:21 SizeLat:16 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:23 SizeLat:22 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:22 Lat:46 SizeLat:44 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'mul_constpow2'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:11 Lat:16 SizeLat:15 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:21 SizeLat:16 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:23 SizeLat:22 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:27 Lat:19 SizeLat:33 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'mul_constpow2'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:5 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:11 Lat:23 SizeLat:16 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:13 Lat:19 SizeLat:15 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'mul_constpow2'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:7 for: %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:14 for: %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:24 SizeLat:28 for: %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SLM-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:11 SizeLat:7 for: %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:2 Lat:22 SizeLat:14 for: %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SLM-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:4 Lat:44 SizeLat:28 for: %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SLM-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:17 Lat:24 SizeLat:22 for: %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:34 Lat:48 SizeLat:44 for: %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:68 Lat:96 SizeLat:88 for: %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = mul i64 undef, 16
  %V2i64 = mul <2 x i64> undef, <i64 8, i64 16>
  %V4i64 = mul <4 x i64> undef, <i64 2, i64 4, i64 8, i64 16>
  %V8i64 = mul <8 x i64> undef, <i64 2, i64 4, i64 8, i64 16, i64 32, i64 64, i64 128, i64 256>

  %I32 = mul i32 undef, 16
  %V4i32 = mul <4 x i32> undef, <i32 2, i32 4, i32 8, i32 16>
  %V8i32 = mul <8 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>
  %V16i32 = mul <16 x i32> undef, <i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256, i32 2, i32 4, i32 8, i32 16, i32 32, i32 64, i32 128, i32 256>

  %I16 = mul i16 undef, 16
  %V8i16 = mul <8 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
  %V16i16 = mul <16 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>
  %V32i16 = mul <32 x i16> undef, <i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256, i16 2, i16 4, i16 8, i16 16, i16 32, i16 64, i16 128, i16 256>

  %I8 = mul i8 undef, 16
  %V16i8 = mul <16 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
  %V32i8 = mul <32 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>
  %V64i8 = mul <64 x i8> undef, <i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16, i8 2, i8 4, i8 8, i8 16>

  ret i32 undef
}

define i32 @mul_uniformconstpow2() {
; SSE2-LABEL: 'mul_uniformconstpow2'
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:14 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:28 SizeLat:12 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'mul_uniformconstpow2'
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:14 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:28 SizeLat:12 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'mul_uniformconstpow2'
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:14 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:28 SizeLat:12 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'mul_uniformconstpow2'
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:4 Lat:6 SizeLat:5 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:10 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:7 SizeLat:8 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:14 SizeLat:16 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'mul_uniformconstpow2'
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:4 SizeLat:4 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:8 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'mul_uniformconstpow2'
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:7 SizeLat:4 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:10 SizeLat:7 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:8 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:5 Lat:12 SizeLat:6 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'mul_uniformconstpow2'
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:8 SizeLat:3 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:8 SizeLat:3 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'mul_uniformconstpow2'
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I64 = mul i64 undef, 16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = mul <2 x i64> undef, splat (i64 16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, splat (i64 16)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = mul <8 x i64> undef, splat (i64 16)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I32 = mul i32 undef, 16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = mul <4 x i32> undef, splat (i32 16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, splat (i32 16)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V16i32 = mul <16 x i32> undef, splat (i32 16)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I16 = mul i16 undef, 16
; SLM-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = mul <8 x i16> undef, splat (i16 16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, splat (i16 16)
; SLM-NEXT:  Cost Model: Found costs of 4 for: %V32i16 = mul <32 x i16> undef, splat (i16 16)
; SLM-NEXT:  Cost Model: Found costs of 1 for: %I8 = mul i8 undef, 16
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:7 SizeLat:3 for: %V16i8 = mul <16 x i8> undef, splat (i8 16)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:14 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 16)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:28 SizeLat:12 for: %V64i8 = mul <64 x i8> undef, splat (i8 16)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = mul i64 undef, 16
  %V2i64 = mul <2 x i64> undef, <i64 16, i64 16>
  %V4i64 = mul <4 x i64> undef, <i64 16, i64 16, i64 16, i64 16>
  %V8i64 = mul <8 x i64> undef, <i64 16, i64 16, i64 16, i64 16, i64 16, i64 16, i64 16, i64 16>

  %I32 = mul i32 undef, 16
  %V4i32 = mul <4 x i32> undef, <i32 16, i32 16, i32 16, i32 16>
  %V8i32 = mul <8 x i32> undef, <i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>
  %V16i32 = mul <16 x i32> undef, <i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>

  %I16 = mul i16 undef, 16
  %V8i16 = mul <8 x i16> undef, <i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16>
  %V16i16 = mul <16 x i16> undef, <i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16>
  %V32i16 = mul <32 x i16> undef, <i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16, i16 16>

  %I8 = mul i8 undef, 16
  %V16i8 = mul <16 x i8> undef, <i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16>
  %V32i8 = mul <32 x i8> undef, <i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16>
  %V64i8 = mul <64 x i8> undef, <i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16, i8 16>

  ret i32 undef
}

define i32 @mul_constnegpow2() {
; SSE2-LABEL: 'mul_constnegpow2'
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:8 SizeLat:9 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:16 SizeLat:18 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:32 SizeLat:36 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:8 Lat:9 SizeLat:8 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:15 Lat:17 SizeLat:15 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:29 Lat:33 SizeLat:29 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:11 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:21 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:27 Lat:22 SizeLat:29 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:53 Lat:43 SizeLat:57 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:105 Lat:85 SizeLat:113 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'mul_constnegpow2'
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:8 SizeLat:9 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:16 SizeLat:18 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:32 SizeLat:36 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:8 Lat:9 SizeLat:8 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:15 Lat:17 SizeLat:15 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:29 Lat:33 SizeLat:29 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:11 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:21 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:27 Lat:22 SizeLat:29 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:53 Lat:43 SizeLat:57 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:105 Lat:85 SizeLat:113 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'mul_constnegpow2'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:6 Lat:8 SizeLat:9 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:12 Lat:16 SizeLat:18 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:24 Lat:32 SizeLat:36 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:12 SizeLat:2 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:3 Lat:23 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:5 Lat:45 SizeLat:5 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:11 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:21 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:18 Lat:25 SizeLat:23 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:35 Lat:49 SizeLat:45 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:69 Lat:97 SizeLat:89 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'mul_constnegpow2'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:5 SizeLat:7 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:16 Lat:9 SizeLat:21 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:32 Lat:18 SizeLat:42 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:4 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:10 Lat:10 SizeLat:16 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:20 Lat:20 SizeLat:32 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:10 SizeLat:12 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:20 Lat:20 SizeLat:24 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:12 Lat:22 SizeLat:18 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:32 Lat:24 SizeLat:46 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:64 Lat:48 SizeLat:92 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'mul_constnegpow2'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:4 SizeLat:2 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:2 Lat:5 SizeLat:4 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:10 SizeLat:8 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:4 SizeLat:4 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:2 Lat:5 SizeLat:5 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:10 SizeLat:10 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:4 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:12 SizeLat:8 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:12 Lat:22 SizeLat:17 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:12 Lat:24 SizeLat:24 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:24 Lat:48 SizeLat:48 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'mul_constnegpow2'
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:4 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:16 Lat:23 SizeLat:20 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:12 Lat:22 SizeLat:17 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:12 Lat:24 SizeLat:24 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:32 Lat:26 SizeLat:38 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'mul_constnegpow2'
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:9 SizeLat:6 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:12 Lat:24 SizeLat:17 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:20 SizeLat:16 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'mul_constnegpow2'
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:8 SizeLat:9 for: %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:12 Lat:16 SizeLat:18 for: %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:24 Lat:32 SizeLat:36 for: %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:2 Lat:12 SizeLat:8 for: %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:3 Lat:23 SizeLat:15 for: %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SLM-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:5 Lat:45 SizeLat:29 for: %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:6 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:3 Lat:11 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:5 Lat:21 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:18 Lat:25 SizeLat:23 for: %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:35 Lat:49 SizeLat:45 for: %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:69 Lat:97 SizeLat:89 for: %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = mul i64 undef, -16
  %V2i64 = mul <2 x i64> undef, <i64 -8, i64 -16>
  %V4i64 = mul <4 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16>
  %V8i64 = mul <8 x i64> undef, <i64 -2, i64 -4, i64 -8, i64 -16, i64 -32, i64 -64, i64 -128, i64 -256>

  %I32 = mul i32 undef, -16
  %V4i32 = mul <4 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16>
  %V8i32 = mul <8 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>
  %V16i32 = mul <16 x i32> undef, <i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256, i32 -2, i32 -4, i32 -8, i32 -16, i32 -32, i32 -64, i32 -128, i32 -256>

  %I16 = mul i16 undef, -16
  %V8i16 = mul <8 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
  %V16i16 = mul <16 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>
  %V32i16 = mul <32 x i16> undef, <i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256, i16 -2, i16 -4, i16 -8, i16 -16, i16 -32, i16 -64, i16 -128, i16 -256>

  %I8 = mul i8 undef, -16
  %V16i8 = mul <16 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
  %V32i8 = mul <32 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>
  %V64i8 = mul <64 x i8> undef, <i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16, i8 -2, i8 -4, i8 -8, i8 -16>

  ret i32 undef
}

define i32 @mul_uniformconstnegpow2() {
; SSE2-LABEL: 'mul_uniformconstnegpow2'
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:15 SizeLat:7 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:29 SizeLat:13 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'mul_uniformconstnegpow2'
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:15 SizeLat:7 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:29 SizeLat:13 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'mul_uniformconstnegpow2'
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:3 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:6 SizeLat:6 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:12 SizeLat:12 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:15 SizeLat:7 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:29 SizeLat:13 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'mul_uniformconstnegpow2'
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:2 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:8 SizeLat:11 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:18 Lat:16 SizeLat:22 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:8 SizeLat:11 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:18 Lat:16 SizeLat:22 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:3 SizeLat:2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:8 SizeLat:11 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:18 Lat:16 SizeLat:22 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; AVX1-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:12 Lat:9 SizeLat:14 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:24 Lat:18 SizeLat:28 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'mul_uniformconstnegpow2'
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:3 SizeLat:4 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:8 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:3 SizeLat:4 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:8 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:2 Lat:3 SizeLat:4 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:8 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; AVX2-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:9 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:9 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:6 Lat:18 SizeLat:12 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'mul_uniformconstnegpow2'
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:8 SizeLat:6 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:17 SizeLat:12 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:9 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:9 SizeLat:6 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:10 Lat:19 SizeLat:11 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'mul_uniformconstnegpow2'
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:9 SizeLat:4 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:9 SizeLat:4 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'mul_uniformconstnegpow2'
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I64 = mul i64 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:2 Lat:3 SizeLat:3 for: %V2i64 = mul <2 x i64> undef, splat (i64 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:4 Lat:6 SizeLat:6 for: %V4i64 = mul <4 x i64> undef, splat (i64 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:8 Lat:12 SizeLat:12 for: %V8i64 = mul <8 x i64> undef, splat (i64 -16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I32 = mul i32 undef, -16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = mul <4 x i32> undef, splat (i32 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V8i32 = mul <8 x i32> undef, splat (i32 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V16i32 = mul <16 x i32> undef, splat (i32 -16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I16 = mul i16 undef, -16
; SLM-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = mul <8 x i16> undef, splat (i16 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:3 Lat:3 SizeLat:3 for: %V16i16 = mul <16 x i16> undef, splat (i16 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:5 Lat:5 SizeLat:5 for: %V32i16 = mul <32 x i16> undef, splat (i16 -16)
; SLM-NEXT:  Cost Model: Found costs of 2 for: %I8 = mul i8 undef, -16
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:3 Lat:8 SizeLat:4 for: %V16i8 = mul <16 x i8> undef, splat (i8 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:15 SizeLat:7 for: %V32i8 = mul <32 x i8> undef, splat (i8 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:9 Lat:29 SizeLat:13 for: %V64i8 = mul <64 x i8> undef, splat (i8 -16)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = mul i64 undef, -16
  %V2i64 = mul <2 x i64> undef, <i64 -16, i64 -16>
  %V4i64 = mul <4 x i64> undef, <i64 -16, i64 -16, i64 -16, i64 -16>
  %V8i64 = mul <8 x i64> undef, <i64 -16, i64 -16, i64 -16, i64 -16, i64 -16, i64 -16, i64 -16, i64 -16>

  %I32 = mul i32 undef, -16
  %V4i32 = mul <4 x i32> undef, <i32 -16, i32 -16, i32 -16, i32 -16>
  %V8i32 = mul <8 x i32> undef, <i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16>
  %V16i32 = mul <16 x i32> undef, <i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16, i32 -16>

  %I16 = mul i16 undef, -16
  %V8i16 = mul <8 x i16> undef, <i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16>
  %V16i16 = mul <16 x i16> undef, <i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16>
  %V32i16 = mul <32 x i16> undef, <i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16, i16 -16>

  %I8 = mul i8 undef, -16
  %V16i8 = mul <16 x i8> undef, <i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16>
  %V32i8 = mul <32 x i8> undef, <i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16>
  %V64i8 = mul <64 x i8> undef, <i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16, i8 -16>

  ret i32 undef
}
