/*
 * GS1 AI checker generated by "backend/tools/gen_gs1_lint.php" from
 * https://raw.githubusercontent.com/gs1/gs1-syntax-dictionary/main/gs1-syntax-dictionary.txt
 */
/*
    libzint - the open source barcode library
    Copyright (C) 2021-2025 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_GS1_LINT_H
#define Z_GS1_LINT_H

/* N18,csum,gcppos2 (Used by SSCC) */
static int gs1_n18_csum_gcppos2(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 18
            && gs1_csum(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos2(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos2(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 0);
}

/* N14,csum,gcppos2 (Used by GTIN, CONTENT, MTO GTIN) */
static int gs1_n14_csum_gcppos2(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 14
            && gs1_csum(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos2(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos2(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 0);
}

/* X..20 (Used by BATCH/LOT, SERIAL, CPV, PCN, GLN EXTENSION COMPONENT, SHIP TO POST, RTN TO POST, REFURB LOT, ...) */
static int gs1_x__20(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 20
            && gs1_cset82(data, data_len, 0, 1, 20, p_err_no, p_err_posn, err_msg);
}

/* N6,yymmd0 (Used by PROD DATE, DUE DATE, PACK DATE, BEST BEFORE or BEST BY, SELL BY, USE BY or EXPIRY) */
static int gs1_n6_yymmd0(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 6
            && gs1_yymmd0(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmd0(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0);
}

/* N2 (Used by VARIANT) */
static int gs1_n2(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 2
            && gs1_numeric(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg);
}

/* X..28 (Used by TPX) */
static int gs1_x__28(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 28
            && gs1_cset82(data, data_len, 0, 1, 28, p_err_no, p_err_posn, err_msg);
}

/* X..30 (Used by ADDITIONAL ID, CUST. PART No., SECONDARY SERIAL, REF. TO SOURCE, ORDER NUMBER, ROUTE, SHIP TO...) */
static int gs1_x__30(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 30
            && gs1_cset82(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg);
}

/* N..6 (Used by MTO VARIANT) */
static int gs1_n__6(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 6
            && gs1_numeric(data, data_len, 0, 1, 6, p_err_no, p_err_posn, err_msg);
}

/* N13,csum,gcppos1 [X..17] (Used by GDTI) */
static int gs1_n13_csum_gcppos1__x__17_(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 13 && data_len <= 30
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_cset82(data, data_len, 13, 0, 17, p_err_no, p_err_posn, err_msg);
}

/* N13,csum,gcppos1 [N..12] (Used by GCN) */
static int gs1_n13_csum_gcppos1__n__12_(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 13 && data_len <= 25
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 13, 0, 12, p_err_no, p_err_posn, err_msg);
}

/* N..8 (Used by VAR. COUNT, COUNT) */
static int gs1_n__8(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 8
            && gs1_numeric(data, data_len, 0, 1, 8, p_err_no, p_err_posn, err_msg);
}

/* N6 (Used by NET WEIGHT (kg), LENGTH (m), WIDTH (m), HEIGHT (m), AREA (m²), NET VOLUME (l), NET VOLUME (m³)...) */
static int gs1_n6(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 6
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg);
}

/* N..15 (Used by AMOUNT, PRICE) */
static int gs1_n__15(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 15
            && gs1_numeric(data, data_len, 0, 1, 15, p_err_no, p_err_posn, err_msg);
}

/* N3,iso4217 N..15 (Used by AMOUNT, PRICE) */
static int gs1_n3_iso4217_n__15(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 4 && data_len <= 18
            && gs1_iso4217(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso4217(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 3, 1, 15, p_err_no, p_err_posn, err_msg);
}

/* N4 (Used by PRCNT OFF, POINTS) */
static int gs1_n4(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 4
            && gs1_numeric(data, data_len, 0, 4, 4, p_err_no, p_err_posn, err_msg);
}

/* X..30,gcppos1 (Used by GINC, GIAI - ASSEMBLY, GIAI) */
static int gs1_x__30_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 30
            && gs1_gcppos1(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg)
            && gs1_gcppos1(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg, 0);
}

/* N17,csum,gcppos1 (Used by GSIN) */
static int gs1_n17_csum_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 17
            && gs1_csum(data, data_len, 0, 17, 17, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 17, 17, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 17, 17, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 17, 17, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 17, 17, p_err_no, p_err_posn, err_msg, 0);
}

/* N13,csum,gcppos1 (Used by SHIP TO LOC, BILL TO, PURCHASE FROM, SHIP FOR LOC, LOC No., PAY TO, PROD/SERV LOC,...) */
static int gs1_n13_csum_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 13
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg, 0);
}

/* N3,iso3166 X..9 (Used by SHIP TO POST) */
static int gs1_n3_iso3166_x__9(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 4 && data_len <= 12
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_cset82(data, data_len, 3, 1, 9, p_err_no, p_err_posn, err_msg);
}

/* N3,iso3166 (Used by ORIGIN, COUNTRY - PROCESS, COUNTRY - FULL PROCESS) */
static int gs1_n3_iso3166(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 3
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0);
}

/* N3,iso3166 [N3],iso3166 [N3],iso3166 [N3],iso3166 [N3],iso3166 (Used by COUNTRY - INITIAL PROCESS, COUNTRY -...) */
static int gs1_n3_iso3166__n3__iso3166__n3__iso3166__n3__iso3166__n3__iso3166(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 3 && data_len <= 15
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_iso3166(data, data_len, 3, 0, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_iso3166(data, data_len, 6, 0, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_iso3166(data, data_len, 9, 0, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_iso3166(data, data_len, 12, 0, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 3, 0, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 3, 0, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 0, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 6, 0, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 9, 0, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 9, 0, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 12, 0, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166(data, data_len, 12, 0, 3, p_err_no, p_err_posn, err_msg, 0);
}

/* X..3 (Used by ORIGIN SUBDIVISION, AQUATIC SPECIES) */
static int gs1_x__3(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 3
            && gs1_cset82(data, data_len, 0, 1, 3, p_err_no, p_err_posn, err_msg);
}

/* X..35,pcenc (Used by SHIP TO COMP, SHIP TO NAME, RTN TO COMP, RTN TO NAME, SRV DESCRIPTION) */
static int gs1_x__35_pcenc(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 35
            && gs1_pcenc(data, data_len, 0, 1, 35, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 35, p_err_no, p_err_posn, err_msg)
            && gs1_pcenc(data, data_len, 0, 1, 35, p_err_no, p_err_posn, err_msg, 0);
}

/* X..70,pcenc (Used by SHIP TO ADD1, SHIP TO ADD2, SHIP TO SUB, SHIP TO LOC, SHIP TO REG, RTN TO ADD1, RTN TO ...) */
static int gs1_x__70_pcenc(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 70
            && gs1_pcenc(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg)
            && gs1_pcenc(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 0);
}

/* X2,iso3166alpha2 (Used by SHIP TO COUNTRY, RTN TO COUNTRY) */
static int gs1_x2_iso3166alpha2(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 2
            && gs1_iso3166alpha2(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166alpha2(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg, 0);
}

/* N10,latitude N10,longitude (Used by SHIP TO GEO) */
static int gs1_n10_latitude_n10_longitude(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 20
            && gs1_latitude(data, data_len, 0, 10, 10, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_longitude(data, data_len, 10, 10, 10, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 10, 10, p_err_no, p_err_posn, err_msg)
            && gs1_latitude(data, data_len, 0, 10, 10, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 10, 10, 10, p_err_no, p_err_posn, err_msg)
            && gs1_longitude(data, data_len, 10, 10, 10, p_err_no, p_err_posn, err_msg, 0);
}

/* N1,yesno (Used by DANGEROUS GOODS, AUTH TO LEAVE, SIG REQUIRED) */
static int gs1_n1_yesno(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 1
            && gs1_yesno(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_yesno(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 0);
}

/* N6,yymmd0 N4,hhmi (Used by NOT BEF DEL DT, NOT AFT DEL DT) */
static int gs1_n6_yymmd0_n4_hhmi(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 10
            && gs1_yymmd0(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hhmi(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmd0(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg)
            && gs1_hhmi(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* N6,yymmdd (Used by REL DATE, FIRST FREEZE DATE) */
static int gs1_n6_yymmdd(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 6
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0);
}

/* N6 [X1],hyphen (Used by MAX TEMP F., MAX TEMP C., MIN TEMP F., MIN TEMP C.) */
static int gs1_n6__x1__hyphen(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 6 && data_len <= 7
            && gs1_hyphen(data, data_len, 6, 0, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_cset82(data, data_len, 6, 0, 1, p_err_no, p_err_posn, err_msg)
            && gs1_hyphen(data, data_len, 6, 0, 1, p_err_no, p_err_posn, err_msg, 0);
}

/* N13 (Used by NSN) */
static int gs1_n13(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 13
            && gs1_numeric(data, data_len, 0, 13, 13, p_err_no, p_err_posn, err_msg);
}

/* N6,yymmdd N4,hhmi (Used by EXPIRY TIME) */
static int gs1_n6_yymmdd_n4_hhmi(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 10
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hhmi(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg)
            && gs1_hhmi(data, data_len, 6, 4, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* N..4 (Used by ACTIVE POTENCY) */
static int gs1_n__4(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 4
            && gs1_numeric(data, data_len, 0, 1, 4, p_err_no, p_err_posn, err_msg);
}

/* X..12 (Used by CATCH AREA) */
static int gs1_x__12(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 12
            && gs1_cset82(data, data_len, 0, 1, 12, p_err_no, p_err_posn, err_msg);
}

/* N6,yymmdd [N6],yymmdd (Used by HARVEST DATE) */
static int gs1_n6_yymmdd__n6__yymmdd(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 6 && data_len <= 12
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_yymmdd(data, data_len, 6, 0, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 0, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 6, 0, 6, p_err_no, p_err_posn, err_msg, 0);
}

/* X..10 (Used by FISHING GEAR TYPE, SUFFIX) */
static int gs1_x__10(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 10
            && gs1_cset82(data, data_len, 0, 1, 10, p_err_no, p_err_posn, err_msg);
}

/* X..2 (Used by PROD METHOD) */
static int gs1_x__2(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 2
            && gs1_cset82(data, data_len, 0, 1, 2, p_err_no, p_err_posn, err_msg);
}

/* N6,yymmdd [N4],hhmi (Used by TEST BY DATE) */
static int gs1_n6_yymmdd__n4__hhmi(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 6 && data_len <= 10
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hhmi(data, data_len, 6, 0, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 0, 4, p_err_no, p_err_posn, err_msg)
            && gs1_hhmi(data, data_len, 6, 0, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* N3,iso3166999 X..27 (Used by PROCESSOR # 0, PROCESSOR # 1, PROCESSOR # 2, PROCESSOR # 3, PROCESSOR # 4, PROC...) */
static int gs1_n3_iso3166999_x__27(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 4 && data_len <= 30
            && gs1_iso3166999(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_iso3166999(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_cset82(data, data_len, 3, 1, 27, p_err_no, p_err_posn, err_msg);
}

/* N1 X1 X1 X1,importeridx (Used by UIC+EXT) */
static int gs1_n1_x1_x1_x1_importeridx(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 4
            && gs1_importeridx(data, data_len, 3, 1, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_cset82(data, data_len, 1, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_cset82(data, data_len, 2, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_cset82(data, data_len, 3, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_importeridx(data, data_len, 3, 1, 1, p_err_no, p_err_posn, err_msg, 0);
}

/* X..4,packagetype (Used by UFRGT UNIT TYPE) */
static int gs1_x__4_packagetype(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 4
            && gs1_packagetype(data, data_len, 0, 1, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 4, p_err_no, p_err_posn, err_msg)
            && gs1_packagetype(data, data_len, 0, 1, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* X2 X..28 (Used by CERT # 1, CERT # 2, CERT # 3, CERT # 4, CERT # 5, CERT # 6, CERT # 7, CERT # 8, CERT # 9, ...) */
static int gs1_x2_x__28(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 3 && data_len <= 30
            && gs1_cset82(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg)
            && gs1_cset82(data, data_len, 2, 1, 28, p_err_no, p_err_posn, err_msg);
}

/* N2,mediatype (Used by AIDC MEDIA TYPE) */
static int gs1_n2_mediatype(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 2
            && gs1_mediatype(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg)
            && gs1_mediatype(data, data_len, 0, 2, 2, p_err_no, p_err_posn, err_msg, 0);
}

/* X..25 (Used by VCN, REF No.) */
static int gs1_x__25(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 25
            && gs1_cset82(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg);
}

/* N8,yyyymmdd (Used by DOB) */
static int gs1_n8_yyyymmdd(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 8
            && gs1_yyyymmdd(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg)
            && gs1_yyyymmdd(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg, 0);
}

/* N8,yyyymmdd N4,hhmi (Used by DOB TIME) */
static int gs1_n8_yyyymmdd_n4_hhmi(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 12
            && gs1_yyyymmdd(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hhmi(data, data_len, 8, 4, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg)
            && gs1_yyyymmdd(data, data_len, 0, 8, 8, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 8, 4, 4, p_err_no, p_err_posn, err_msg)
            && gs1_hhmi(data, data_len, 8, 4, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* N1,iso5218 (Used by BIO SEX) */
static int gs1_n1_iso5218(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 1
            && gs1_iso5218(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_iso5218(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 0);
}

/* X..40,pcenc (Used by FAMILY NAME, GIVEN NAME, BABY) */
static int gs1_x__40_pcenc(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 40
            && gs1_pcenc(data, data_len, 0, 1, 40, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 40, p_err_no, p_err_posn, err_msg)
            && gs1_pcenc(data, data_len, 0, 1, 40, p_err_no, p_err_posn, err_msg, 0);
}

/* X..90,pcenc (Used by FULL NAME) */
static int gs1_x__90_pcenc(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 90
            && gs1_pcenc(data, data_len, 0, 1, 90, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 90, p_err_no, p_err_posn, err_msg)
            && gs1_pcenc(data, data_len, 0, 1, 90, p_err_no, p_err_posn, err_msg, 0);
}

/* X3,posinseqslash (Used by BIRTH SEQUENCE) */
static int gs1_x3_posinseqslash(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 3
            && gs1_posinseqslash(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_posinseqslash(data, data_len, 0, 3, 3, p_err_no, p_err_posn, err_msg, 0);
}

/* N4,nonzero N5,nonzero N3,nonzero N1,winding N1 (Used by DIMENSIONS) */
static int gs1_n4_nonzero_n5_nonzero_n3_nonzero_n1_winding_n1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 14
            && gs1_nonzero(data, data_len, 0, 4, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_nonzero(data, data_len, 4, 5, 5, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_nonzero(data, data_len, 9, 3, 3, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_winding(data, data_len, 12, 1, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 4, 4, p_err_no, p_err_posn, err_msg)
            && gs1_nonzero(data, data_len, 0, 4, 4, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 4, 5, 5, p_err_no, p_err_posn, err_msg)
            && gs1_nonzero(data, data_len, 4, 5, 5, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 9, 3, 3, p_err_no, p_err_posn, err_msg)
            && gs1_nonzero(data, data_len, 9, 3, 3, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 12, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_winding(data, data_len, 12, 1, 1, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 13, 1, 1, p_err_no, p_err_posn, err_msg);
}

/* N1,zero N13,csum,gcppos1 [X..16] (Used by GRAI) */
static int gs1_n1_zero_n13_csum_gcppos1__x__16_(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 14 && data_len <= 30
            && gs1_zero(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_csum(data, data_len, 1, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 1, 13, 13, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg)
            && gs1_zero(data, data_len, 0, 1, 1, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 1, 13, 13, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 1, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 1, 13, 13, p_err_no, p_err_posn, err_msg, 0)
            && gs1_cset82(data, data_len, 14, 0, 16, p_err_no, p_err_posn, err_msg);
}

/* N14,csum,gcppos2 N4,pieceoftotal (Used by ITIP, ITIP CONTENT) */
static int gs1_n14_csum_gcppos2_n4_pieceoftotal(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 18
            && gs1_csum(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos2(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_pieceoftotal(data, data_len, 14, 4, 4, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos2(data, data_len, 0, 14, 14, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 14, 4, 4, p_err_no, p_err_posn, err_msg)
            && gs1_pieceoftotal(data, data_len, 14, 4, 4, p_err_no, p_err_posn, err_msg, 0);
}

/* X..34,iban (Used by IBAN) */
static int gs1_x__34_iban(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 34
            && gs1_iban(data, data_len, 0, 1, 34, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 34, p_err_no, p_err_posn, err_msg)
            && gs1_iban(data, data_len, 0, 1, 34, p_err_no, p_err_posn, err_msg, 0);
}

/* N6,yymmdd N2,hh [N2],mi [N2],ss (Used by PROD TIME) */
static int gs1_n6_yymmdd_n2_hh__n2__mi__n2__ss(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 8 && data_len <= 12
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hh(data, data_len, 6, 2, 2, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_mi(data, data_len, 8, 0, 2, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_ss(data, data_len, 10, 0, 2, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg)
            && gs1_yymmdd(data, data_len, 0, 6, 6, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 6, 2, 2, p_err_no, p_err_posn, err_msg)
            && gs1_hh(data, data_len, 6, 2, 2, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 8, 0, 2, p_err_no, p_err_posn, err_msg)
            && gs1_mi(data, data_len, 8, 0, 2, p_err_no, p_err_posn, err_msg, 0)
            && gs1_numeric(data, data_len, 10, 0, 2, p_err_no, p_err_posn, err_msg)
            && gs1_ss(data, data_len, 10, 0, 2, p_err_no, p_err_posn, err_msg, 0);
}

/* X..50 (Used by OPTSEN) */
static int gs1_x__50(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 50
            && gs1_cset82(data, data_len, 0, 1, 50, p_err_no, p_err_posn, err_msg);
}

/* Y..30,gcppos1 (Used by CPID) */
static int gs1_y__30_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 30
            && gs1_gcppos1(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset39(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg)
            && gs1_gcppos1(data, data_len, 0, 1, 30, p_err_no, p_err_posn, err_msg, 0);
}

/* N..12,nozeroprefix (Used by CPID SERIAL) */
static int gs1_n__12_nozeroprefix(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 12
            && gs1_nozeroprefix(data, data_len, 0, 1, 12, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 1, 12, p_err_no, p_err_posn, err_msg)
            && gs1_nozeroprefix(data, data_len, 0, 1, 12, p_err_no, p_err_posn, err_msg, 0);
}

/* X..25,csumalpha,gcppos1 (Used by GMN) */
static int gs1_x__25_csumalpha_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 25
            && gs1_csumalpha(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg)
            && gs1_csumalpha(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 0);
}

/* X..25,csumalpha,gcppos1,hasnondigit (Used by MUDI) */
static int gs1_x__25_csumalpha_gcppos1_hasnondigit(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 25
            && gs1_csumalpha(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_hasnondigit(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg)
            && gs1_csumalpha(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 0)
            && gs1_hasnondigit(data, data_len, 0, 1, 25, p_err_no, p_err_posn, err_msg, 0);
}

/* N18,csum,gcppos1 (Used by GSRN - PROVIDER, GSRN - RECIPIENT) */
static int gs1_n18_csum_gcppos1(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 18
            && gs1_csum(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_gcppos1(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_numeric(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg)
            && gs1_csum(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 0)
            && gs1_gcppos1(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg, 0);
}

/* N..10 (Used by SRIN) */
static int gs1_n__10(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 10
            && gs1_numeric(data, data_len, 0, 1, 10, p_err_no, p_err_posn, err_msg);
}

/* Z..90 (Used by DIGSIG) */
static int gs1_z__90(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 90
            && gs1_cset64(data, data_len, 0, 1, 90, p_err_no, p_err_posn, err_msg);
}

/* N15 (Used by IMEI, IMEI2) */
static int gs1_n15(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 15
            && gs1_numeric(data, data_len, 0, 15, 15, p_err_no, p_err_posn, err_msg);
}

/* N32 (Used by ESIM) */
static int gs1_n32(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len == 32
            && gs1_numeric(data, data_len, 0, 32, 32, p_err_no, p_err_posn, err_msg);
}

/* N18 [N..2] (Used by PSIM) */
static int gs1_n18__n__2_(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 18 && data_len <= 20
            && gs1_numeric(data, data_len, 0, 18, 18, p_err_no, p_err_posn, err_msg)
            && gs1_numeric(data, data_len, 18, 0, 2, p_err_no, p_err_posn, err_msg);
}

/* X..70,couponcode */
static int gs1_x__70_couponcode(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 70
            && gs1_couponcode(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg)
            && gs1_couponcode(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 0);
}

/* X..70,couponposoffer */
static int gs1_x__70_couponposoffer(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 70
            && gs1_couponposoffer(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 1 /*length_only*/)
            && gs1_cset82(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg)
            && gs1_couponposoffer(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg, 0);
}

/* X..70 (Used by PRODUCT URL) */
static int gs1_x__70(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 70
            && gs1_cset82(data, data_len, 0, 1, 70, p_err_no, p_err_posn, err_msg);
}

/* X..90 (Used by INTERNAL) */
static int gs1_x__90(const unsigned char *data,
            const int data_len, int *p_err_no, int *p_err_posn, char err_msg[50]) {
    return data_len >= 1 && data_len <= 90
            && gs1_cset82(data, data_len, 0, 1, 90, p_err_no, p_err_posn, err_msg);
}

/* Entry point. Returns 1 on success, 0 on failure: `*p_err_no` set to 1 if unknown AI, 2 if bad data length */
static int gs1_lint(const int ai, const unsigned char *data, const int data_len, int *p_err_no, int *p_err_posn,
            char err_msg[50]) {

    /* Assume data length failure */
    *p_err_no = 2;

    if (ai < 100) {

        if (ai == 0) {
            return gs1_n18_csum_gcppos2(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 1 && ai <= 3) {
            return gs1_n14_csum_gcppos2(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 10 || ai == 21 || ai == 22) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if ((ai >= 11 && ai <= 13) || (ai >= 15 && ai <= 17)) {
            return gs1_n6_yymmd0(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 20) {
            return gs1_n2(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 30 || ai == 37) {
            return gs1_n__8(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 90) {
            return gs1_x__30(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 91) {
            return gs1_x__90(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 300) {

        if (ai == 235) {
            return gs1_x__28(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 240 || ai == 241 || ai == 250 || ai == 251) {
            return gs1_x__30(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 242) {
            return gs1_n__6(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 243 || ai == 254) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 253) {
            return gs1_n13_csum_gcppos1__x__17_(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 255) {
            return gs1_n13_csum_gcppos1__n__12_(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 500) {

        if (ai == 400 || ai == 403) {
            return gs1_x__30(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 401) {
            return gs1_x__30_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 402) {
            return gs1_n17_csum_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 410 && ai <= 417) {
            return gs1_n13_csum_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 420) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 421) {
            return gs1_n3_iso3166_x__9(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 422 || ai == 424 || ai == 426) {
            return gs1_n3_iso3166(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 423 || ai == 425) {
            return gs1_n3_iso3166__n3__iso3166__n3__iso3166__n3__iso3166__n3__iso3166(data,
                        data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 427) {
            return gs1_x__3(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 800) {

        if (ai >= 710 && ai <= 717) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3200) {

        if ((ai >= 3100 && ai <= 3105) || (ai >= 3110 && ai <= 3115) || (ai >= 3120 && ai <= 3125)
                || (ai >= 3130 && ai <= 3135) || (ai >= 3140 && ai <= 3145) || (ai >= 3150 && ai <= 3155)
                || (ai >= 3160 && ai <= 3165)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3300) {

        if (ai <= 3205 || (ai >= 3210 && ai <= 3215) || (ai >= 3220 && ai <= 3225) || (ai >= 3230 && ai <= 3235)
                || (ai >= 3240 && ai <= 3245) || (ai >= 3250 && ai <= 3255) || (ai >= 3260 && ai <= 3265)
                || (ai >= 3270 && ai <= 3275) || (ai >= 3280 && ai <= 3285) || (ai >= 3290 && ai <= 3295)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3400) {

        if (ai <= 3305 || (ai >= 3310 && ai <= 3315) || (ai >= 3320 && ai <= 3325) || (ai >= 3330 && ai <= 3335)
                || (ai >= 3340 && ai <= 3345) || (ai >= 3350 && ai <= 3355) || (ai >= 3360 && ai <= 3365)
                || (ai >= 3370 && ai <= 3375)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3500) {

        if (ai <= 3405 || (ai >= 3410 && ai <= 3415) || (ai >= 3420 && ai <= 3425) || (ai >= 3430 && ai <= 3435)
                || (ai >= 3440 && ai <= 3445) || (ai >= 3450 && ai <= 3455) || (ai >= 3460 && ai <= 3465)
                || (ai >= 3470 && ai <= 3475) || (ai >= 3480 && ai <= 3485) || (ai >= 3490 && ai <= 3495)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3600) {

        if (ai <= 3505 || (ai >= 3510 && ai <= 3515) || (ai >= 3520 && ai <= 3525) || (ai >= 3530 && ai <= 3535)
                || (ai >= 3540 && ai <= 3545) || (ai >= 3550 && ai <= 3555) || (ai >= 3560 && ai <= 3565)
                || (ai >= 3570 && ai <= 3575)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 3700) {

        if (ai <= 3605 || (ai >= 3610 && ai <= 3615) || (ai >= 3620 && ai <= 3625) || (ai >= 3630 && ai <= 3635)
                || (ai >= 3640 && ai <= 3645) || (ai >= 3650 && ai <= 3655) || (ai >= 3660 && ai <= 3665)
                || (ai >= 3670 && ai <= 3675) || (ai >= 3680 && ai <= 3685) || (ai >= 3690 && ai <= 3695)) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 4000) {

        if ((ai >= 3900 && ai <= 3909) || (ai >= 3920 && ai <= 3929)) {
            return gs1_n__15(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if ((ai >= 3910 && ai <= 3919) || (ai >= 3930 && ai <= 3939)) {
            return gs1_n3_iso4217_n__15(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 3940 && ai <= 3943) {
            return gs1_n4(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 3950 && ai <= 3955) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 4400) {

        if (ai == 4300 || ai == 4301 || ai == 4310 || ai == 4311 || ai == 4320) {
            return gs1_x__35_pcenc(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if ((ai >= 4302 && ai <= 4306) || (ai >= 4312 && ai <= 4316)) {
            return gs1_x__70_pcenc(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4307 || ai == 4317) {
            return gs1_x2_iso3166alpha2(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4308 || ai == 4319) {
            return gs1_x__30(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4309) {
            return gs1_n10_latitude_n10_longitude(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4318) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 4321 && ai <= 4323) {
            return gs1_n1_yesno(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4324 || ai == 4325) {
            return gs1_n6_yymmd0_n4_hhmi(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 4326) {
            return gs1_n6_yymmdd(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 4330 && ai <= 4333) {
            return gs1_n6__x1__hyphen(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 7100) {

        if (ai == 7001) {
            return gs1_n13(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7002) {
            return gs1_x__30(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7003) {
            return gs1_n6_yymmdd_n4_hhmi(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7004) {
            return gs1_n__4(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7005) {
            return gs1_x__12(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7006) {
            return gs1_n6_yymmdd(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7007) {
            return gs1_n6_yymmdd__n6__yymmdd(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7008) {
            return gs1_x__3(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7009) {
            return gs1_x__10(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7010) {
            return gs1_x__2(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7011) {
            return gs1_n6_yymmdd__n4__hhmi(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 7020 && ai <= 7022) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7023) {
            return gs1_x__30_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai >= 7030 && ai <= 7039) {
            return gs1_n3_iso3166999_x__27(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7040) {
            return gs1_n1_x1_x1_x1_importeridx(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7041) {
            return gs1_x__4_packagetype(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 7300) {

        if (ai >= 7230 && ai <= 7239) {
            return gs1_x2_x__28(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7240) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7241) {
            return gs1_n2_mediatype(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7242) {
            return gs1_x__25(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7250) {
            return gs1_n8_yyyymmdd(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7251) {
            return gs1_n8_yyyymmdd_n4_hhmi(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7252) {
            return gs1_n1_iso5218(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7253 || ai == 7254 || ai == 7259) {
            return gs1_x__40_pcenc(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7255) {
            return gs1_x__10(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7256) {
            return gs1_x__90_pcenc(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7257) {
            return gs1_x__70_pcenc(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 7258) {
            return gs1_x3_posinseqslash(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 8100) {

        if (ai == 8001) {
            return gs1_n4_nonzero_n5_nonzero_n3_nonzero_n1_winding_n1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8002 || ai == 8012) {
            return gs1_x__20(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8003) {
            return gs1_n1_zero_n13_csum_gcppos1__x__16_(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8004) {
            return gs1_x__30_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8005) {
            return gs1_n6(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8006 || ai == 8026) {
            return gs1_n14_csum_gcppos2_n4_pieceoftotal(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8007) {
            return gs1_x__34_iban(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8008) {
            return gs1_n6_yymmdd_n2_hh__n2__mi__n2__ss(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8009) {
            return gs1_x__50(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8010) {
            return gs1_y__30_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8011) {
            return gs1_n__12_nozeroprefix(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8013) {
            return gs1_x__25_csumalpha_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8014) {
            return gs1_x__25_csumalpha_gcppos1_hasnondigit(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8017 || ai == 8018) {
            return gs1_n18_csum_gcppos1(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8019) {
            return gs1_n__10(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8020) {
            return gs1_x__25(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8030) {
            return gs1_z__90(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8040 || ai == 8041) {
            return gs1_n15(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8042) {
            return gs1_n32(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8043) {
            return gs1_n18__n__2_(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 8200) {

        if (ai == 8110) {
            return gs1_x__70_couponcode(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8111) {
            return gs1_n4(data, data_len, p_err_no, p_err_posn, err_msg);
        }
        if (ai == 8112) {
            return gs1_x__70_couponposoffer(data, data_len, p_err_no, p_err_posn, err_msg);
        }

    } else if (ai < 8300) {

        if (ai == 8200) {
            return gs1_x__70(data, data_len, p_err_no, p_err_posn, err_msg);
        }
    }

    /* Unknown AI */
    *p_err_no = 1;
    return 0;
}

#endif /* Z_GS1_LINT_H */
