/* $OpenBSD: gost.h,v 1.1 2023/07/08 14:30:44 beck Exp $ */
/*
 * Copyright (c) 2023 Bob Beck <beck@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBCRYPTO_GOST_H
#define _LIBCRYPTO_GOST_H

#ifndef _MSC_VER
#include_next <openssl/gost.h>
#else
#include "../include/openssl/gost.h"
#endif
#include "crypto_namespace.h"

LCRYPTO_USED(Gost2814789_set_sbox);
LCRYPTO_USED(Gost2814789_set_key);
LCRYPTO_USED(Gost2814789_ecb_encrypt);
LCRYPTO_USED(Gost2814789_cfb64_encrypt);
LCRYPTO_USED(Gost2814789_cnt_encrypt);
LCRYPTO_USED(GOST_CIPHER_PARAMS_new);
LCRYPTO_USED(GOST_CIPHER_PARAMS_free);
LCRYPTO_USED(d2i_GOST_CIPHER_PARAMS);
LCRYPTO_USED(i2d_GOST_CIPHER_PARAMS);
LCRYPTO_USED(GOST2814789IMIT_Init);
LCRYPTO_USED(GOST2814789IMIT_Update);
LCRYPTO_USED(GOST2814789IMIT_Final);
LCRYPTO_USED(GOST2814789IMIT_Transform);
LCRYPTO_USED(GOST2814789IMIT);
LCRYPTO_USED(GOSTR341194_Init);
LCRYPTO_USED(GOSTR341194_Update);
LCRYPTO_USED(GOSTR341194_Final);
LCRYPTO_USED(GOSTR341194_Transform);
LCRYPTO_USED(GOSTR341194);
LCRYPTO_USED(STREEBOG256_Init);
LCRYPTO_USED(STREEBOG256_Update);
LCRYPTO_USED(STREEBOG256_Final);
LCRYPTO_USED(STREEBOG256);
LCRYPTO_USED(STREEBOG512_Init);
LCRYPTO_USED(STREEBOG512_Update);
LCRYPTO_USED(STREEBOG512_Final);
LCRYPTO_USED(STREEBOG512_Transform);
LCRYPTO_USED(STREEBOG512);
LCRYPTO_USED(GOST_KEY_new);
LCRYPTO_USED(GOST_KEY_free);
LCRYPTO_USED(GOST_KEY_check_key);
LCRYPTO_USED(GOST_KEY_set_public_key_affine_coordinates);
LCRYPTO_USED(GOST_KEY_get0_group);
LCRYPTO_USED(GOST_KEY_set_group);
LCRYPTO_USED(GOST_KEY_get_digest);
LCRYPTO_USED(GOST_KEY_set_digest);
LCRYPTO_USED(GOST_KEY_get0_private_key);
LCRYPTO_USED(GOST_KEY_set_private_key);
LCRYPTO_USED(GOST_KEY_get0_public_key);
LCRYPTO_USED(GOST_KEY_set_public_key);
LCRYPTO_USED(GOST_KEY_get_size);
LCRYPTO_USED(ERR_load_GOST_strings);

#endif /* _LIBCRYPTO_GOST_H */
